/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.actions;

import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.GuiceDependencies;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.PrivilegesEvaluationResult;
import com.floragunn.searchguard.configuration.ClusterInfoHolder;
import com.floragunn.searchguard.support.SnapshotRestoreHelper;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Function;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.main.MainRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotUtils;
import org.elasticsearch.transport.RemoteClusterService;

public class ActionRequestIntrospector {
    private static final IndicesOptions EXACT = new IndicesOptions(EnumSet.noneOf(IndicesOptions.Option.class), EnumSet.noneOf(IndicesOptions.WildcardStates.class));
    private static final Set<String> NAME_BASED_SHORTCUTS_FOR_CLUSTER_ACTIONS = ImmutableSet.of((Object)"indices:data/read/msearch/template", (Object[])new String[]{"indices:data/read/search/template", "indices:data/read/sql/translate", "indices:data/read/sql", "indices:data/read/sql/close_cursor", "cluster:admin/scripts/painless/execute"});
    private static final Logger log = LogManager.getLogger(ActionRequestIntrospector.class);
    private final IndexNameExpressionResolver resolver;
    private final ClusterService clusterService;
    private final ClusterInfoHolder clusterInfoHolder;
    private final GuiceDependencies guiceDependencies;
    private final ActionRequestInfo UNKNOWN = new ActionRequestInfo(true, false);
    private final ActionRequestInfo CLUSTER_REQUEST = new ActionRequestInfo(true, false);
    private static final ResolvedIndices LOCAL_ALL = new ResolvedIndices(true, (ImmutableSet<String>)ImmutableSet.empty(), (ImmutableSet<String>)ImmutableSet.empty(), (ImmutableSet<IndicesRequestInfo>)ImmutableSet.empty());
    private static final ResolvedIndices EMPTY = new ResolvedIndices(false, (ImmutableSet<String>)ImmutableSet.empty(), (ImmutableSet<String>)ImmutableSet.empty(), (ImmutableSet<IndicesRequestInfo>)ImmutableSet.empty());

    public ActionRequestIntrospector(IndexNameExpressionResolver resolver, ClusterService clusterService, ClusterInfoHolder clusterInfoHolder, GuiceDependencies guiceDependencies) {
        this.resolver = resolver;
        this.clusterService = clusterService;
        this.clusterInfoHolder = clusterInfoHolder;
        this.guiceDependencies = guiceDependencies;
    }

    public ActionRequestInfo getActionRequestInfo(String action, Object request) {
        if (NAME_BASED_SHORTCUTS_FOR_CLUSTER_ACTIONS.contains(action)) {
            return this.CLUSTER_REQUEST;
        }
        if (request instanceof IndicesRequest) {
            if (request instanceof PutMappingRequest) {
                PutMappingRequest putMappingRequest = (PutMappingRequest)request;
                if (putMappingRequest.getConcreteIndex() != null) {
                    return new ActionRequestInfo(putMappingRequest.getConcreteIndex().getName(), EXACT);
                }
                return new ActionRequestInfo((IndicesRequest)putMappingRequest);
            }
            if (request instanceof FieldCapabilitiesIndexRequest) {
                return new ActionRequestInfo(((FieldCapabilitiesIndexRequest)request).index(), EXACT);
            }
            if (request instanceof ResizeRequest) {
                ResizeRequest resizeRequest = (ResizeRequest)request;
                return new ActionRequestInfo(resizeRequest.getSourceIndex(), EXACT).additional("target", (IndicesRequest)((ResizeRequest)request).getTargetIndexRequest());
            }
            return new ActionRequestInfo((IndicesRequest)request);
        }
        if (request instanceof CompositeIndicesRequest) {
            if (request instanceof BulkRequest) {
                return new ActionRequestInfo(((BulkRequest)request).requests());
            }
            if (request instanceof MultiGetRequest) {
                return new ActionRequestInfo(((MultiGetRequest)request).getItems());
            }
            if (request instanceof MultiSearchRequest) {
                return new ActionRequestInfo(((MultiSearchRequest)request).requests());
            }
            if (request instanceof MultiTermVectorsRequest) {
                return new ActionRequestInfo(((MultiTermVectorsRequest)request).getRequests());
            }
            if (request instanceof ReindexRequest) {
                return this.CLUSTER_REQUEST;
            }
            log.warn("Unknown action request: " + request.getClass().getName());
            return this.UNKNOWN;
        }
        if (request instanceof RestoreSnapshotRequest) {
            if (this.clusterInfoHolder.isLocalNodeElectedMaster() == Boolean.FALSE) {
                return this.UNKNOWN;
            }
            RestoreSnapshotRequest restoreRequest = (RestoreSnapshotRequest)request;
            SnapshotInfo snapshotInfo = SnapshotRestoreHelper.getSnapshotInfo(restoreRequest, this.guiceDependencies.getRepositoriesService());
            if (snapshotInfo == null) {
                log.warn("snapshot repository '" + restoreRequest.repository() + "', snapshot '" + restoreRequest.snapshot() + "' not found");
                return this.UNKNOWN;
            }
            List requestedResolvedIndices = SnapshotUtils.filterIndices((List)snapshotInfo.indices(), (String[])restoreRequest.indices(), (IndicesOptions)restoreRequest.indicesOptions());
            List<String> renamedTargetIndices = this.renamedIndices(restoreRequest, requestedResolvedIndices);
            if (log.isDebugEnabled()) {
                log.debug("snapshot {} contains {}", (Object)snapshotInfo.snapshotId().getName(), renamedTargetIndices);
            }
            return new ActionRequestInfo(renamedTargetIndices, EXACT);
        }
        if (request instanceof BaseNodesRequest) {
            return this.CLUSTER_REQUEST;
        }
        if (request instanceof MainRequest) {
            return this.CLUSTER_REQUEST;
        }
        if (request instanceof ClearScrollRequest) {
            return this.CLUSTER_REQUEST;
        }
        if (request instanceof SearchScrollRequest) {
            return this.CLUSTER_REQUEST;
        }
        if (action.startsWith("index:")) {
            log.warn("Unknown action request: " + request.getClass().getName());
        } else {
            log.debug("Unknown action request: " + request.getClass().getName());
        }
        return this.UNKNOWN;
    }

    public PrivilegesEvaluationResult reduceIndices(String action, Object request, Set<String> keepIndices, ActionRequestInfo actionRequestInfo) throws PrivilegesEvaluationException {
        if (request instanceof IndicesRequest.Replaceable) {
            IndicesRequest.Replaceable replaceableIndicesRequest = (IndicesRequest.Replaceable)request;
            ResolvedIndices resolvedIndices = this.getResolvedIndices((IndicesRequest)replaceableIndicesRequest, actionRequestInfo);
            ImmutableSet<String> actualIndices = resolvedIndices.getLocalIndices();
            if (keepIndices.containsAll((Collection<?>)actualIndices)) {
                return PrivilegesEvaluationResult.OK;
            }
            if (!replaceableIndicesRequest.indicesOptions().ignoreUnavailable() && !ActionRequestIntrospector.containsWildcard((IndicesRequest)replaceableIndicesRequest)) {
                return PrivilegesEvaluationResult.INSUFFICIENT;
            }
            ImmutableSet newIndices = actualIndices.intersection(keepIndices).with(resolvedIndices.getRemoteIndices());
            if (log.isTraceEnabled()) {
                log.trace("reduceIndicesForIgnoreUnavailable: keep: " + keepIndices + " actual: " + actualIndices + "; newIndices: " + newIndices);
            }
            if (newIndices.size() > 0) {
                replaceableIndicesRequest.indices(this.toArray((ImmutableSet<String>)newIndices));
                this.validateIndexReduction(action, replaceableIndicesRequest, keepIndices);
                return PrivilegesEvaluationResult.OK;
            }
            return PrivilegesEvaluationResult.EMPTY;
        }
        return PrivilegesEvaluationResult.INSUFFICIENT;
    }

    private void validateIndexReduction(String action, Object request, Set<String> keepIndices) throws PrivilegesEvaluationException {
        ActionRequestInfo newInfo = this.getActionRequestInfo(action, request);
        if (!keepIndices.containsAll((Collection<?>)newInfo.getResolvedIndices().getLocalIndices())) {
            throw new PrivilegesEvaluationException("Indices were not properly reduced: " + request + "/" + newInfo.getResolvedIndices() + "; keep: " + keepIndices);
        }
    }

    public boolean forceEmptyResult(Object request) throws PrivilegesEvaluationException {
        if (request instanceof IndicesRequest.Replaceable) {
            IndicesRequest.Replaceable replaceableIndicesRequest = (IndicesRequest.Replaceable)request;
            if (replaceableIndicesRequest.indicesOptions().expandWildcardsOpen() || replaceableIndicesRequest.indicesOptions().expandWildcardsClosed()) {
                replaceableIndicesRequest.indices(new String[]{".force_no_index*", "-*"});
            } else {
                replaceableIndicesRequest.indices(new String[0]);
            }
            this.validateIndexReduction("", replaceableIndicesRequest, Collections.emptySet());
            return true;
        }
        return false;
    }

    public boolean replaceIndices(Object request, Function<ResolvedIndices, List<String>> replacementFunction, ActionRequestInfo actionRequestInfo) {
        if (request instanceof IndicesRequest) {
            if (request instanceof IndicesRequest.Replaceable) {
                IndicesRequest.Replaceable replaceableIndicesRequest = (IndicesRequest.Replaceable)request;
                String[] indices = this.applyReplacementFunction((IndicesRequest)replaceableIndicesRequest, replacementFunction, actionRequestInfo);
                if (indices.length > 0) {
                    replaceableIndicesRequest.indices(indices);
                    return true;
                }
                return false;
            }
            if (request instanceof SingleShardRequest) {
                SingleShardRequest singleShardRequest = (SingleShardRequest)request;
                String[] indices = this.applyReplacementFunction((IndicesRequest)singleShardRequest, replacementFunction, actionRequestInfo);
                if (indices.length == 1) {
                    singleShardRequest.index(indices[0]);
                    return true;
                }
                return false;
            }
        } else if (request instanceof CompositeIndicesRequest) {
            if (request instanceof MultiSearchRequest) {
                for (SearchRequest searchRequest : ((MultiSearchRequest)request).requests()) {
                    if (this.replaceIndices(searchRequest, replacementFunction, actionRequestInfo)) continue;
                    return false;
                }
                return true;
            }
            if (request instanceof MultiTermVectorsRequest) {
                for (TermVectorsRequest termVectorsRequest : ((MultiTermVectorsRequest)request).getRequests()) {
                    if (this.replaceIndices(termVectorsRequest, replacementFunction, actionRequestInfo)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private ResolvedIndices getResolvedIndices(IndicesRequest indicesRequest, ActionRequestInfo actionRequestInfo) {
        if (actionRequestInfo != null && actionRequestInfo.isFor(indicesRequest)) {
            return actionRequestInfo.getResolvedIndices();
        }
        return new ActionRequestInfo(indicesRequest).getResolvedIndices();
    }

    private String[] applyReplacementFunction(IndicesRequest indicesRequest, Function<ResolvedIndices, List<String>> replacementFunction, ActionRequestInfo actionRequestInfo) {
        ResolvedIndices resolvedIndices = this.getResolvedIndices(indicesRequest, actionRequestInfo);
        ArrayList<String> replacedLocalIndices = new ArrayList<String>((Collection)replacementFunction.apply(resolvedIndices));
        replacedLocalIndices.addAll((Collection<String>)resolvedIndices.getRemoteIndices());
        return replacedLocalIndices.toArray(new String[replacedLocalIndices.size()]);
    }

    public ActionRequestInfo create(String index, IndicesOptions indicesOptions) {
        return new ActionRequestInfo((ImmutableSet<IndicesRequestInfo>)ImmutableSet.of((Object)new IndicesRequestInfo(null, index, indicesOptions)));
    }

    private List<String> renamedIndices(RestoreSnapshotRequest request, List<String> filteredIndices) {
        try {
            ArrayList<String> renamedIndices = new ArrayList<String>();
            Iterator<String> iterator = filteredIndices.iterator();
            while (iterator.hasNext()) {
                String index;
                String renamedIndex = index = iterator.next();
                if (request.renameReplacement() != null && request.renamePattern() != null) {
                    renamedIndex = index.replaceAll(request.renamePattern(), request.renameReplacement());
                }
                renamedIndices.add(renamedIndex);
            }
            return renamedIndices;
        }
        catch (PatternSyntaxException e) {
            log.error("Unable to parse the regular expression denoted in 'rename_pattern'. Please correct the pattern an try again.", (Throwable)e);
            throw e;
        }
    }

    private String[] toArray(ImmutableSet<String> set) {
        return (String[])set.toArray((Object[])new String[set.size()]);
    }

    private ImmutableSet<IndicesRequestInfo> from(Collection<? extends IndicesRequest> indicesRequests) {
        if (indicesRequests.isEmpty()) {
            return ImmutableSet.empty();
        }
        IndicesRequest first = null;
        IndicesRequestInfo firstInfo = null;
        HashSet<IndicesRequestInfo> set = null;
        for (IndicesRequest indicesRequest : indicesRequests) {
            if (set != null) {
                set.add(new IndicesRequestInfo(null, indicesRequest));
                continue;
            }
            if (first == null) {
                first = indicesRequest;
                firstInfo = new IndicesRequestInfo(null, indicesRequest);
                continue;
            }
            if (ActionRequestIntrospector.equals(indicesRequest, first)) continue;
            set = new HashSet<IndicesRequestInfo>(indicesRequests.size());
            set.add(firstInfo);
            set.add(new IndicesRequestInfo(null, indicesRequest));
        }
        if (set != null) {
            return ImmutableSet.of(set);
        }
        return ImmutableSet.of(firstInfo);
    }

    private static boolean containsWildcard(Collection<String> indices) {
        return indices == null || indices.stream().anyMatch(i -> i != null && (i.contains("*") || i.equals("_all")));
    }

    private static boolean containsWildcard(String index) {
        return index == null || index.contains("*");
    }

    private static boolean containsWildcard(IndicesRequest request) {
        String[] indices = request.indices();
        if (indices == null || indices.length == 0) {
            return true;
        }
        if (!request.indicesOptions().expandWildcardsOpen() && !request.indicesOptions().expandWildcardsClosed()) {
            return false;
        }
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i].equals("_all") || indices[i].equals("*")) {
                return true;
            }
            if (!Regex.isSimpleMatchPattern((String)indices[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean equals(IndicesRequest a, IndicesRequest b) {
        return Arrays.equals(a.indices(), b.indices()) && Objects.equals(a.indicesOptions(), b.indicesOptions()) && (a instanceof IndicesRequest.Replaceable ? ((IndicesRequest.Replaceable)a).allowsRemoteIndices() : false) == (b instanceof IndicesRequest.Replaceable ? ((IndicesRequest.Replaceable)b).allowsRemoteIndices() : false) && a.includeDataStreams() == b.includeDataStreams();
    }

    public static class ResolvedIndices {
        private final boolean localAll;
        private ImmutableSet<IndicesRequestInfo> deferredRequests;
        private ImmutableSet<String> localIndices;
        protected final ImmutableSet<String> remoteIndices;

        ResolvedIndices(boolean localAll, ImmutableSet<String> localIndices, ImmutableSet<String> remoteIndices, ImmutableSet<IndicesRequestInfo> deferredRequests) {
            this.localAll = localAll;
            this.localIndices = localIndices;
            this.remoteIndices = remoteIndices;
            this.deferredRequests = deferredRequests;
        }

        public boolean isLocalAll() {
            return this.localAll;
        }

        public boolean isLocalIndicesEmpty() {
            return !this.localAll && this.getLocalIndices().isEmpty();
        }

        public boolean containsOnlyRemoteIndices() {
            return !this.localAll && this.deferredRequests.isEmpty() && this.localIndices.isEmpty() && !this.remoteIndices.isEmpty();
        }

        ResolvedIndices with(ResolvedIndices other) {
            if (other == null) {
                return this;
            }
            return new ResolvedIndices(this.localAll || other.localAll, (ImmutableSet<String>)this.localIndices.with(other.localIndices), (ImmutableSet<String>)this.remoteIndices.with(other.remoteIndices), (ImmutableSet<IndicesRequestInfo>)this.deferredRequests.with(other.deferredRequests));
        }

        public ImmutableSet<String> getLocalIndices() {
            if (this.deferredRequests.isEmpty()) {
                return this.localIndices;
            }
            ImmutableSet localIndices = this.localIndices;
            for (IndicesRequestInfo info : this.deferredRequests) {
                localIndices = localIndices.with(info.resolveIndicesNow());
            }
            this.localIndices = localIndices;
            this.deferredRequests = ImmutableSet.empty();
            return localIndices;
        }

        public ImmutableSet<String> getRemoteIndices() {
            return this.remoteIndices;
        }

        public ImmutableSet<String> getLocalAndRemoteIndices() {
            return this.getLocalIndices().with(this.getRemoteIndices());
        }

        public ImmutableSet<String> getLocalSubset(Set<String> superSet) {
            return this.getLocalIndices().intersection(superSet).with(this.remoteIndices);
        }

        public String[] getLocalSubsetAsArray(Set<String> superSet) {
            ImmutableSet<String> result = this.getLocalSubset(superSet);
            return (String[])result.toArray((Object[])new String[result.size()]);
        }

        public String toString() {
            if (this.localAll) {
                if (this.remoteIndices.isEmpty() && !this.deferredRequests.isEmpty()) {
                    return "local: _all";
                }
                StringBuilder result = new StringBuilder("local: _all");
                if (this.deferredRequests.isEmpty()) {
                    result.append(" [").append(this.localIndices.size()).append("]");
                }
                if (!this.remoteIndices.isEmpty()) {
                    result.append("; remote: ").append(this.remoteIndices.toShortString());
                }
                return result.toString();
            }
            return "local: " + (this.localIndices != null ? this.localIndices.toShortString() : "null") + "; remote: " + (this.remoteIndices != null ? this.remoteIndices.toShortString() : "null");
        }

        public ResolvedIndices localIndices(ImmutableSet<String> localIndices) {
            return new ResolvedIndices(false, localIndices, this.remoteIndices, (ImmutableSet<IndicesRequestInfo>)ImmutableSet.empty());
        }

        public ResolvedIndices localIndices(String ... localIndices) {
            return this.localIndices((ImmutableSet<String>)ImmutableSet.ofArray((Object[])localIndices));
        }

        public static ResolvedIndices empty() {
            return EMPTY;
        }
    }

    public class IndicesRequestInfo {
        private final List<String> indices;
        private final String[] indicesArray;
        private final IndicesOptions indicesOptions;
        private final boolean allowsRemoteIndices;
        private final boolean includeDataStreams;
        private final String role;
        private final boolean expandWildcards;
        private final boolean isAll;
        private final boolean containsWildcards;
        private final boolean writeRequest;
        private final boolean createIndexRequest;
        private ImmutableSet<String> remoteIndices;
        private List<String> localIndices;

        IndicesRequestInfo(String role, IndicesRequest indicesRequest) {
            this.indices = indicesRequest.indices() != null ? Arrays.asList(indicesRequest.indices()) : Collections.emptyList();
            this.indicesArray = indicesRequest.indices();
            this.indicesOptions = indicesRequest.indicesOptions();
            this.allowsRemoteIndices = indicesRequest instanceof IndicesRequest.Replaceable ? ((IndicesRequest.Replaceable)indicesRequest).allowsRemoteIndices() : false;
            this.includeDataStreams = indicesRequest.includeDataStreams();
            this.role = role;
            boolean bl = this.expandWildcards = this.indicesOptions.expandWildcardsOpen() || this.indicesOptions.expandWildcardsHidden() || this.indicesOptions.expandWildcardsClosed();
            boolean bl2 = this.expandWildcards ? IndexNameExpressionResolver.isAllIndices(this.indices) || this.indices.size() == 1 && this.indices.iterator().next().equals("*") : (this.isAll = false);
            this.containsWildcards = this.expandWildcards ? this.isAll || ActionRequestIntrospector.containsWildcard(this.indices) : false;
            this.writeRequest = indicesRequest instanceof DocWriteRequest;
            this.createIndexRequest = indicesRequest instanceof IndexRequest || indicesRequest instanceof CreateIndexRequest;
        }

        IndicesRequestInfo(String role, String index, IndicesOptions indicesOptions) {
            this.indices = Collections.singletonList(index);
            this.indicesArray = new String[]{index};
            this.indicesOptions = indicesOptions;
            this.allowsRemoteIndices = true;
            this.includeDataStreams = true;
            this.role = role;
            boolean bl = this.expandWildcards = indicesOptions.expandWildcardsOpen() || indicesOptions.expandWildcardsHidden() || indicesOptions.expandWildcardsClosed();
            boolean bl2 = this.expandWildcards ? IndexNameExpressionResolver.isAllIndices(this.indices) || index.equals("*") : (this.isAll = false);
            this.containsWildcards = this.expandWildcards ? this.isAll || ActionRequestIntrospector.containsWildcard(index) : false;
            this.writeRequest = false;
            this.createIndexRequest = false;
        }

        IndicesRequestInfo(String role, List<String> indices, IndicesOptions indicesOptions) {
            this.indices = indices;
            this.indicesArray = indices.toArray(new String[indices.size()]);
            this.indicesOptions = indicesOptions;
            this.allowsRemoteIndices = true;
            this.includeDataStreams = true;
            this.role = role;
            boolean bl = this.expandWildcards = indicesOptions.expandWildcardsOpen() || indicesOptions.expandWildcardsHidden() || indicesOptions.expandWildcardsClosed();
            boolean bl2 = this.expandWildcards ? IndexNameExpressionResolver.isAllIndices(indices) || indices.size() == 1 && indices.get(0).equals("*") : (this.isAll = false);
            this.containsWildcards = this.expandWildcards ? this.isAll || ActionRequestIntrospector.containsWildcard(this.indices) : false;
            this.writeRequest = false;
            this.createIndexRequest = false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.allowsRemoteIndices ? 1231 : 1237);
            result = 31 * result + (this.includeDataStreams ? 1231 : 1237);
            result = 31 * result + (this.writeRequest ? 1231 : 1237);
            result = 31 * result + (this.createIndexRequest ? 1231 : 1237);
            result = 31 * result + (this.indices == null ? 0 : this.indices.hashCode());
            result = 31 * result + (this.indicesOptions == null ? 0 : this.indicesOptions.hashCode());
            result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IndicesRequestInfo)) {
                return false;
            }
            IndicesRequestInfo other = (IndicesRequestInfo)obj;
            if (this.allowsRemoteIndices != other.allowsRemoteIndices) {
                return false;
            }
            if (this.includeDataStreams != other.includeDataStreams) {
                return false;
            }
            if (this.writeRequest != other.writeRequest) {
                return false;
            }
            if (this.createIndexRequest != other.createIndexRequest) {
                return false;
            }
            if (this.indices == null ? other.indices != null : !this.indices.equals(other.indices)) {
                return false;
            }
            if (this.indicesOptions == null ? other.indicesOptions != null : !this.indicesOptions.equals((Object)other.indicesOptions)) {
                return false;
            }
            return !(this.role == null ? other.role != null : !this.role.equals(other.role));
        }

        public boolean isExpandWildcards() {
            return this.expandWildcards;
        }

        public boolean containsWildcards() {
            return this.containsWildcards;
        }

        public boolean isAll() {
            if (this.expandWildcards) {
                return IndexNameExpressionResolver.isAllIndices(this.indices) || this.indices.size() == 1 && this.indices.get(0).equals("*");
            }
            return false;
        }

        ResolvedIndices resolveIndices() {
            if (this.isAll()) {
                return new ResolvedIndices(true, (ImmutableSet<String>)ImmutableSet.empty(), (ImmutableSet<String>)ImmutableSet.empty(), (ImmutableSet<IndicesRequestInfo>)ImmutableSet.of((Object)this));
            }
            this.checkForRemoteIndices();
            if (this.localIndices.size() == 0) {
                return new ResolvedIndices(false, (ImmutableSet<String>)ImmutableSet.empty(), this.remoteIndices, (ImmutableSet<IndicesRequestInfo>)ImmutableSet.empty());
            }
            if (this.isExpandWildcards() && this.localIndices.size() == 1 && (this.localIndices.contains("_all") || this.localIndices.contains("*"))) {
                return new ResolvedIndices(true, (ImmutableSet<String>)ImmutableSet.empty(), this.remoteIndices, (ImmutableSet<IndicesRequestInfo>)ImmutableSet.of((Object)this));
            }
            return new ResolvedIndices(false, this.resolveIndicesNow(), this.remoteIndices, (ImmutableSet<IndicesRequestInfo>)ImmutableSet.empty());
        }

        ImmutableSet<String> resolveIndicesNow() {
            try {
                this.checkForRemoteIndices();
                if (this.expandWildcards) {
                    try {
                        return ImmutableSet.ofArray((Object[])ActionRequestIntrospector.this.resolver.concreteIndexNames(ActionRequestIntrospector.this.clusterService.state(), this.allowNoIndices(this.indicesOptions), (IndicesRequest)this.asIndicesRequestWithoutRemoteIndices()));
                    }
                    catch (IndexNotFoundException | IndexClosedException | InvalidIndexNameException e) {
                        if (log.isTraceEnabled()) {
                            log.trace("Exception in resolveIndicesNow(). This is expected due to weird implementation choices in concreteIndexNames(). Recovering: " + this, e);
                        }
                        return this.resolveWithoutWildcards();
                    }
                }
                if (this.writeRequest) {
                    return this.resolveWriteIndex();
                }
                if (this.createIndexRequest) {
                    return this.resolveDateMathExpressions();
                }
                return this.resolveWithoutWildcards();
            }
            catch (RuntimeException e) {
                log.error("Error in resolveIndicesNow() for " + this, (Throwable)e);
                throw e;
            }
        }

        private IndicesOptions allowNoIndices(IndicesOptions indicesOptions) {
            if (indicesOptions.allowNoIndices()) {
                return indicesOptions;
            }
            Object newOptions = indicesOptions.getOptions().clone();
            ((AbstractCollection)newOptions).add(IndicesOptions.Option.ALLOW_NO_INDICES);
            return new IndicesOptions((EnumSet)newOptions, indicesOptions.getExpandWildcards());
        }

        private ImmutableSet<String> resolveDateMathExpressions() {
            ImmutableSet result = ImmutableSet.empty();
            for (String index : this.localIndices) {
                result = result.with((Object)ActionRequestIntrospector.this.resolver.resolveDateMathExpression(index));
            }
            return result;
        }

        private ImmutableSet<String> resolveWriteIndex() {
            ImmutableSet result = ImmutableSet.empty();
            for (String index : this.localIndices) {
                Index concreteIndex = ActionRequestIntrospector.this.resolver.concreteWriteIndex(ActionRequestIntrospector.this.clusterService.state(), this.indicesOptions, index, true, this.includeDataStreams);
                if (concreteIndex != null) {
                    result = result.with((Object)concreteIndex.getName());
                    continue;
                }
                result = result.with((Object)ActionRequestIntrospector.this.resolver.resolveDateMathExpression(index));
            }
            return result;
        }

        private ImmutableSet<String> resolveWithoutWildcards() {
            ImmutableSet result = ImmutableSet.empty();
            ClusterState state = ActionRequestIntrospector.this.clusterService.state();
            SortedMap indicesLookup = state.metadata().getIndicesLookup();
            for (String index : this.localIndices) {
                String resolved = ActionRequestIntrospector.this.resolver.resolveDateMathExpression(index);
                IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get(resolved);
                if (indexAbstraction == null) {
                    result = result.with((Object)resolved);
                    continue;
                }
                if (indexAbstraction.getType() == IndexAbstraction.Type.ALIAS && this.indicesOptions.ignoreAliases() || indexAbstraction.isDataStreamRelated() && !this.includeDataStreams) continue;
                result = result.with((Collection)indexAbstraction.getIndices().stream().map(i -> i.getName()).collect(Collectors.toList()));
            }
            return result;
        }

        private void checkForRemoteIndices() {
            if (this.remoteIndices == null || this.localIndices == null) {
                RemoteClusterService remoteClusterService = ActionRequestIntrospector.this.guiceDependencies.getTransportService().getRemoteClusterService();
                if (remoteClusterService.isCrossClusterSearchEnabled() && this.allowsRemoteIndices) {
                    Map groupedIndices = remoteClusterService.groupIndices(this.indicesOptions, this.indicesArray, idx -> ActionRequestIntrospector.this.resolver.hasIndexAbstraction(idx, ActionRequestIntrospector.this.clusterService.state()));
                    OriginalIndices localOriginalIndices = (OriginalIndices)groupedIndices.get("");
                    this.localIndices = localOriginalIndices != null ? Arrays.asList(localOriginalIndices.indices()) : Collections.emptyList();
                    this.remoteIndices = this.buildRemoteIndicesSet(groupedIndices);
                } else {
                    this.localIndices = this.indices;
                    this.remoteIndices = ImmutableSet.empty();
                }
            }
        }

        private ImmutableSet<String> buildRemoteIndicesSet(Map<String, OriginalIndices> groupedIndices) {
            if (groupedIndices.size() == 1 && groupedIndices.containsKey("")) {
                return ImmutableSet.empty();
            }
            HashSet<String> result = new HashSet<String>();
            for (Map.Entry<String, OriginalIndices> entry : groupedIndices.entrySet()) {
                if (entry.getKey().equals("")) continue;
                for (String index : entry.getValue().indices()) {
                    result.add(entry.getKey() + ":" + index);
                }
            }
            return ImmutableSet.of(result);
        }

        public String toString() {
            return "[indices=" + this.indices + ", indicesOptions=" + this.indicesOptions + ", allowsRemoteIndices=" + this.allowsRemoteIndices + ", includeDataStreams=" + this.includeDataStreams + ", role=" + this.role + "]";
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public IndicesRequest.Replaceable asIndicesRequestWithoutRemoteIndices() {
            return new IndicesRequest.Replaceable(){

                public String[] indices() {
                    if (IndicesRequestInfo.this.remoteIndices.isEmpty()) {
                        return IndicesRequestInfo.this.indicesArray;
                    }
                    return IndicesRequestInfo.this.localIndices.toArray(new String[IndicesRequestInfo.this.localIndices.size()]);
                }

                public IndicesOptions indicesOptions() {
                    return IndicesRequestInfo.this.indicesOptions;
                }

                public boolean includeDataStreams() {
                    return IndicesRequestInfo.this.includeDataStreams;
                }

                public IndicesRequest indices(String ... indices) {
                    return this;
                }

                public boolean allowsRemoteIndices() {
                    return IndicesRequestInfo.this.allowsRemoteIndices;
                }
            };
        }
    }

    public class ActionRequestInfo {
        private final boolean unknown;
        private final boolean indexRequest;
        private final ImmutableSet<IndicesRequestInfo> indices;
        private Object sourceRequest;
        private boolean resolvedIndicesInitialized = false;
        private ResolvedIndices resolvedIndices;
        private ImmutableMap<String, ResolvedIndices> additionalResolvedIndices;
        private Boolean containsWildcards;

        ActionRequestInfo(boolean unknown, boolean indexRequest) {
            this.unknown = unknown;
            this.indexRequest = indexRequest;
            this.indices = null;
        }

        ActionRequestInfo(ImmutableSet<IndicesRequestInfo> indices) {
            this.unknown = false;
            this.indexRequest = true;
            this.indices = indices;
        }

        ActionRequestInfo(boolean unknown, boolean indexRequest, ImmutableSet<IndicesRequestInfo> indices) {
            this.unknown = unknown;
            this.indexRequest = indexRequest;
            this.indices = indices;
        }

        ActionRequestInfo(IndicesRequest indices) {
            this((ImmutableSet<IndicesRequestInfo>)ImmutableSet.of((Object)this$0.new IndicesRequestInfo(null, indices)));
            this.sourceRequest = indices;
        }

        ActionRequestInfo(Collection<? extends IndicesRequest> indices) {
            this((ImmutableSet<IndicesRequestInfo>)this$0.from(indices));
        }

        ActionRequestInfo(String index, IndicesOptions indicesOptions) {
            this((ImmutableSet<IndicesRequestInfo>)ImmutableSet.of((Object)this$0.new IndicesRequestInfo(null, index, indicesOptions)));
        }

        ActionRequestInfo(List<String> index, IndicesOptions indicesOptions) {
            this((ImmutableSet<IndicesRequestInfo>)ImmutableSet.of((Object)this$0.new IndicesRequestInfo(null, index, indicesOptions)));
        }

        ActionRequestInfo(boolean unknown, boolean indexRequest, ImmutableSet<IndicesRequestInfo> indices, ResolvedIndices resolvedIndices, ImmutableMap<String, ResolvedIndices> additionalResolvedIndices, Object sourceRequest) {
            this.unknown = unknown;
            this.indexRequest = indexRequest;
            this.indices = indices;
            this.resolvedIndices = resolvedIndices;
            this.resolvedIndicesInitialized = true;
            this.additionalResolvedIndices = additionalResolvedIndices;
            this.sourceRequest = sourceRequest;
        }

        ActionRequestInfo additional(String role, IndicesRequest indices) {
            return new ActionRequestInfo(this.unknown, this.indexRequest, (ImmutableSet<IndicesRequestInfo>)this.indices.with((Object)new IndicesRequestInfo(role, indices)));
        }

        public boolean isUnknown() {
            return this.unknown;
        }

        public boolean isIndexRequest() {
            return this.indexRequest;
        }

        public boolean containsWildcards() {
            if (this.containsWildcards == null) {
                boolean result = this.indices != null ? this.indices.stream().anyMatch(i -> i.containsWildcards()) : false;
                this.containsWildcards = result;
                return result;
            }
            return this.containsWildcards;
        }

        public ActionRequestInfo reducedIndices(ImmutableSet<String> newLocalResolvedIndices) {
            if (!this.resolvedIndicesInitialized) {
                this.initResolvedIndices();
                this.resolvedIndicesInitialized = true;
            }
            return new ActionRequestInfo(this.unknown, this.indexRequest, this.indices, this.resolvedIndices.localIndices(newLocalResolvedIndices), this.additionalResolvedIndices, newLocalResolvedIndices);
        }

        public ResolvedIndices getResolvedIndices() {
            if (!this.resolvedIndicesInitialized) {
                this.initResolvedIndices();
                this.resolvedIndicesInitialized = true;
            }
            return this.resolvedIndices;
        }

        public ImmutableMap<String, ResolvedIndices> getAdditionalResolvedIndices() {
            if (!this.resolvedIndicesInitialized) {
                this.initResolvedIndices();
                this.resolvedIndicesInitialized = true;
            }
            return this.additionalResolvedIndices;
        }

        public boolean ignoreUnavailable() {
            if (this.indices == null || this.indices.size() == 0) {
                return false;
            }
            for (IndicesRequestInfo index : this.indices) {
                if (index.indicesOptions().ignoreUnavailable()) continue;
                return false;
            }
            return true;
        }

        private void initResolvedIndices() {
            if (this.unknown) {
                this.resolvedIndices = LOCAL_ALL;
                this.additionalResolvedIndices = ImmutableMap.empty();
                return;
            }
            if (!this.indexRequest) {
                this.resolvedIndices = null;
                this.additionalResolvedIndices = ImmutableMap.empty();
                return;
            }
            int numberOfEntries = this.indices.size();
            if (numberOfEntries == 0) {
                this.resolvedIndices = LOCAL_ALL;
                this.additionalResolvedIndices = ImmutableMap.empty();
            } else if (numberOfEntries == 1 && ((IndicesRequestInfo)this.indices.only()).role == null) {
                this.resolvedIndices = ((IndicesRequestInfo)this.indices.only()).resolveIndices();
                this.additionalResolvedIndices = ImmutableMap.empty();
            } else {
                ResolvedIndices resolvedIndices = null;
                ImmutableMap additionalResolvedIndicesMap = ImmutableMap.empty();
                for (IndicesRequestInfo info : this.indices) {
                    ResolvedIndices singleResolved = info.resolveIndices();
                    if (info.role == null) {
                        resolvedIndices = singleResolved.with(resolvedIndices);
                        continue;
                    }
                    additionalResolvedIndicesMap = additionalResolvedIndicesMap.withComputed((Object)info.role, additionalResolvedIndices -> singleResolved.with((ResolvedIndices)additionalResolvedIndices));
                }
                this.resolvedIndices = resolvedIndices;
                this.additionalResolvedIndices = additionalResolvedIndicesMap;
            }
        }

        public boolean isFor(Object sourceRequest) {
            return this.sourceRequest == sourceRequest;
        }

        public String toString() {
            if (this.unknown) {
                return "UNKNOWN";
            }
            if (!this.indexRequest) {
                return "CLUSTER_REQUEST";
            }
            return "indices: " + this.getResolvedIndices() + "; additional: " + this.getAdditionalResolvedIndices() + "; source: " + this.indices + "; containsWildcards: " + this.containsWildcards;
        }

        public ImmutableSet<IndicesRequestInfo> getUnresolved() {
            return this.indices;
        }
    }
}

